/* Set up necessary information to encrypt the mail database */
USE [master]
IF (select Count(*) from sys.symmetric_keys where name like '%DatabaseMasterKey%') = 0

BEGIN
/*Generate password for encryption */
DECLARE @sql varchar(400)
DECLARE @pass varchar(32)
SET @pass = ''

SET @sql = 'CREATE MASTER KEY ENCRYPTION BY PASSWORD = ' + '''' + @pass + ''''
EXEC(@sql)

PRINT 'Database encrypted with the following passphrase (save in password safe): ' + @pass
END

IF (select Count(*) from sys.certificates where name = 'TDE_Certificate') = 0
BEGIN
CREATE certificate TDE_Certificate WITH subject = 'Database TDE certificate';
END
/* End encryption set-up */

USE direct;
ALTER TABLE flags ADD message_id [bigint] NULL;
GO
UPDATE flags SET message_id = 0;
ALTER TABLE flags ALTER COLUMN message_id [bigint] NOT NULL;
ALTER TABLE workflow_items ADD message_id [bigint] NULL;
GO
UPDATE workflow_items SET message_id = 0;
ALTER TABLE workflow_items ALTER COLUMN message_id [bigint] NOT NULL;

GO
/****** Object:  Table [dbo].[role_permissions]    Script Date: 04/11/2014 10:47:30 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[role_permissions](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[role_name] [varchar](150) NOT NULL,
	[permission_id] [bigint] NOT NULL,
 CONSTRAINT [PK_role_permissions] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET IDENTITY_INSERT [dbo].[role_permissions] ON
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (1, N'groupleader', 1)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (2, N'groupleader', 7)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (3, N'groupleader', 25)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (4, N'groupleader', 27)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (5, N'facilityleader', 1)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (6, N'facilityleader', 5)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (7, N'facilityleader', 21)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (8, N'facilityleader', 7)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (9, N'facilityleader', 26)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (11, N'facilityleader', 27)
SET IDENTITY_INSERT [dbo].[role_permissions] OFF
/****** Object:  Table [dbo].[permissions]    Script Date: 04/11/2014 10:47:30 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[permissions](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[name] [varchar](100) NOT NULL,
	[parent_id] [bigint] NULL,
 CONSTRAINT [PK_permissions] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET IDENTITY_INSERT [dbo].[permissions] ON
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (1, N'adminpanel', NULL)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (2, N'logs', 1)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (3, N'reports', 1)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (4, N'themes', 1)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (5, N'manage_users', 1)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (6, N'distribution_lists', 1)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (7, N'manage_groups', 1)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (8, N'logs_logins', 2)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (9, N'logs_sent_mail', 2)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (10, N'logs_received_mail', 2)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (11, N'logs_edit', 2)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (12, N'logs_feedback', 2)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (13, N'reports_sent_messages', 3)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (14, N'reports_attachment_types', 3)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (15, N'reports_login_errors', 3)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (16, N'reports_login_success', 3)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (17, N'reports_unique_logins', 3)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (18, N'reports_average_size', 3)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (19, N'reports_message_success', 3)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (20, N'manage_users_all', 5)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (21, N'manage_users_facilities', 5)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (22, N'manage_users_create', 5)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (23, N'distribution_lists_create', 6)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (24, N'manage_groups_all', 7)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (25, N'manage_groups_groups', 7)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (26, N'manage_groups_facilities', 7)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (27, N'manage_groups_create', 7)
SET IDENTITY_INSERT [dbo].[permissions] OFF


USE api;
DECLARE @SQL VARCHAR(4000)
SET @SQL = 'ALTER TABLE account_request DROP CONSTRAINT |ConstraintName| '
SET @SQL = REPLACE(@SQL, '|ConstraintName|', (SELECT name FROM sysobjects WHERE xtype = 'PK' AND parent_obj = OBJECT_ID('account_request')))
EXEC(@SQL)
GO
ALTER TABLE account_request ALTER COLUMN id [bigint] NOT NULL;
ALTER TABLE account_request ADD PRIMARY KEY CLUSTERED ([id] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
/*ALTER TABLE account_request ADD username varchar(100) NULL;
ALTER TABLE account_request ADD facility_id [bigint] NULL;*/

/* Drop existing Foreign Keys so we can recreate */
DECLARE @SQL VARCHAR(4000)
SET @SQL = 'ALTER TABLE request DROP CONSTRAINT |ConstraintName| '
SET @SQL = REPLACE(@SQL, '|ConstraintName|', (SELECT name FROM sysobjects WHERE xtype = 'F' AND parent_obj = OBJECT_ID('request')))
EXEC(@SQL)
GO

DECLARE @SQL VARCHAR(4000)
SET @SQL = 'ALTER TABLE application DROP CONSTRAINT |ConstraintName| '
SET @SQL = REPLACE(@SQL, '|ConstraintName|', (SELECT name FROM sysobjects WHERE xtype = 'F' AND parent_obj = OBJECT_ID('application')))
EXEC(@SQL)
GO

/* Drop existing Primary Keys so we can recreate */
DECLARE @SQL VARCHAR(4000)
SET @SQL = 'ALTER TABLE application DROP CONSTRAINT |ConstraintName| '
SET @SQL = REPLACE(@SQL, '|ConstraintName|', (SELECT name FROM sysobjects WHERE xtype = 'PK' AND parent_obj = OBJECT_ID('application')))
EXEC(@SQL)
GO

DECLARE @SQL VARCHAR(4000)
SET @SQL = 'ALTER TABLE request DROP CONSTRAINT |ConstraintName| '
SET @SQL = REPLACE(@SQL, '|ConstraintName|', (SELECT name FROM sysobjects WHERE xtype = 'PK' AND parent_obj = OBJECT_ID('request')))
EXEC(@SQL)
GO

DECLARE @SQL VARCHAR(4000)
SET @SQL = 'ALTER TABLE application_request DROP CONSTRAINT |ConstraintName| '
SET @SQL = REPLACE(@SQL, '|ConstraintName|', (SELECT name FROM sysobjects WHERE xtype = 'PK' AND parent_obj = OBJECT_ID('application_request')))
EXEC(@SQL)
GO

ALTER TABLE application ALTER COLUMN id [bigint] NOT NULL;
ALTER TABLE request ALTER COLUMN id [bigint] NOT NULL;
ALTER TABLE request ALTER COLUMN application_id [bigint] NULL;
ALTER TABLE request ALTER COLUMN response varchar(max);
ALTER TABLE application ALTER COLUMN app_request_id [bigint] NOT NULL;
ALTER TABLE application_request ALTER COLUMN id [bigint] NOT NULL;
ALTER TABLE account_request ADD username varchar(100) NULL;
ALTER TABLE account_request ADD facility_id [bigint] NULL;

ALTER TABLE application ADD PRIMARY KEY CLUSTERED ([id] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
ALTER TABLE application_request ADD PRIMARY KEY CLUSTERED ([id] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
ALTER TABLE request WITH CHECK ADD CONSTRAINT [FK_request_application] FOREIGN KEY ([application_id]) REFERENCES [dbo].[application] ([id])
ALTER TABLE [dbo].[application]  WITH CHECK ADD CONSTRAINT [FK_application_application_request] FOREIGN KEY([app_request_id]) REFERENCES [dbo].[application_request] ([id])

USE [api];
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[web_services]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[web_services](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[name] [varchar](200) NOT NULL,
	[description] [varchar](4000) NULL,
 CONSTRAINT [PK_web_services] PRIMARY KEY NONCLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END
SET ANSI_PADDING OFF

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[web_services]') AND type in (N'U'))
BEGIN
SET IDENTITY_INSERT [dbo].[web_services] ON
INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (1, N'send', N'Allows application to send a direct message on your behalf')
INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (2, N'retrieve', N'Allows application to retrieve your messages')
INSERT [dbo].[web_services] ([id], [name], [description]) VALUES (3, N'manage', N'Allows application to manage messages and folders')
SET IDENTITY_INSERT [dbo].[web_services] OFF
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[application_account_link]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[application_account_link](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[app_id] [bigint] NOT NULL,
	[unique_id] [varchar](64) NOT NULL,
	[created_at] [bigint] NOT NULL,
	[org_id] [bigint] NULL,
	[system_permissions] [nvarchar](100) NULL,
 CONSTRAINT [PK_application_account_link] PRIMARY KEY CLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END
SET ANSI_PADDING OFF

IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_application_account_link_application]') AND parent_object_id = OBJECT_ID(N'[dbo].[application_account_link]'))
BEGIN
ALTER TABLE [dbo].[application_account_link]  WITH CHECK ADD CONSTRAINT [FK_application_account_link_application] FOREIGN KEY([app_id])
REFERENCES [dbo].[application] ([id])
END

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[facility]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[facility](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[name] [varchar](400) NOT NULL,
	[active] [tinyint] NOT NULL,
PRIMARY KEY CLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
SET ANSI_PADDING OFF

INSERT INTO facility ( name, active ) VALUES
( 'VA Boston Healthcare System (523)', 1 ),
( 'VA Connecticut Healthcare System (689)', 1 ),
( 'Bedford Veterans Hospital (518)', 1 ),
( 'Manchester VA Medical Center (608)', 1 ),
( 'Providence VA Medical Center (650)', 1 ),
( 'VA Central Western Massachusetts Healthcare System (631)', 1 ),
( 'VA Maine Healthcare System - Togus (402)', 1 ),
( 'White River Junction VA Medical Center (405)', 1 ),
( 'VA Western New York Healthcare System (528)', 1 ),
( 'Albany VA Medical Center (528A8)', 1 ),
( 'Bath VA Medical Center (528A6)', 1 ),
( 'Canandaigua VA Medical Center (528A5)', 1 ),
( 'Syracuse VA Medical Center (528A7)', 1 ),
( 'VA Hudson Valley Health Care System (620)', 1 ),
( 'VA New Jersey Health Care System (561)', 1 ),
( 'VA NY Harbor Healthcare System (630)', 1 ),
( 'Bronx VA Medical Center (526)', 1 ),
( 'Northport VA Medical Center (632)', 1 ),
( 'VA Pittsburgh Healthcare Center (646)', 1 ),
( 'Altoona VA Medical Center (503)', 1 ),
( 'Clarksburg VA Medical Center (540)', 1 ),
( 'Coatesville VA Medical Center (542)', 1 ),
( 'Erie VA Medical Center (562)', 1 ),
( 'Lebanon VA Medical Center (595)', 1 ),
( 'Philadelphia VA Medical Center (642)', 1 ),
( 'VA Butler Healthcare (529)', 1 ),
( 'Wilkes-Barre VA Medical Center (693)', 1 ),
( 'Wilmington VA Medical Center (460)', 1 ),
( 'Baltimore VA Medical Center (512)', 1 ),
( 'Loch Raven VA Community Living & Rehabilitation Center (512GB)', 1 ),
( 'Martinsburg VA Medical Center (613)', 1 ),
( 'Perry Point VA Medical Center (512A5)', 1 ),
( 'Washington DC VA Medical Center (688)', 1 ),
( 'Asheville VA Medical Center (637)', 1 ),
( 'Beckley VA Medical Center (517)', 1 ),
( 'Durham VA Medical Center (558)', 1 ),
( 'Fayetteville VA Medical Center (565)', 1 ),
( 'Hampton VA Medical Center (590)', 1 ),
( 'Richmond VA Medical Center (652)', 1 ),
( 'Salem VA Medical Center (658)', 1 ),
( 'Salisbury VA Medical Center (659)', 1 ),
( 'Atlanta VA Medical Center (508)', 1 ),
( 'Birmingham VA Medical Center (521)', 1 ),
( 'Dublin VA Medical Center (557)', 1 ),
( 'Central Alabama Veterans Health Care System (619A4)', 1 ),
( 'Augusta VA Medical Center (509)', 1 ),
( '       ton VA Medical Center (534)', 1 ),
( 'Tuscaloosa VA Medical Center (679)', 1 ),
( 'Columbia SC VA Medical Center (544)', 1 ),
( 'VA Caribbean Healthcare System (672)', 1 ),
( 'Bay Pines VA Medical Center (516)', 1 ),
( 'Tampa Veterans Hospital (673)', 1 ),
( 'Lake City VA Medical Center (573A4)', 1 ),
( 'Gainesville VA Medical Center (573)', 1 ),
( 'Miami VA Healthcare System (546)', 1 ),
( 'Orlando VA Medical Center (675)', 1 ),
( 'West Palm Beach VA Medical Center (548)', 1 ),
( 'Tennessee Valley Healthcare System (626)', 1 ),
( '    ington VA Medical Center (581)', 1 ),
( 'Lexington VA Medical Center (596)', 1 ),
( 'Memphis VA Medical Center (614)', 1 ),
( 'Mountain Home VA Medical Center (621)', 1 ),
( 'Louisville VA Medical Center (603)', 1 ),
( 'Columbus VA Medical Center (757)', 1 ),
( 'Chillicothe VA Medical Center (538)', 1 ),
( 'Cincinnati VA Medical Center (539)', 1 ),
( 'Dayton VA Medical Center (552)', 1 ),
( 'Cleveland VA Medical Center (541)', 1 ),
( 'VA Northern Indiana Health Care System (610)', 1 ),
( 'Saginaw VA Medical Center (655)', 1 ),
( 'Battle Creek VA Medical Center (515)', 1 ),
( 'Detroit VA Medical Center (553)', 1 ),
( 'Indianapolis VA Medical Center (583)', 1 ),
( 'VA Ann Arbor Healthcare System (506)', 1 ),
( 'VA Illiana Health Care System (550)', 1 ),
( 'North Chicago Federal Health Care Center (556)', 1 ),
( 'Milwaukee VA Medical Center (695)', 1 ),
( 'Hines VA Hospital (578)', 1 ),
( 'Chicago VA Medical Center (537)', 1 ),
( 'Iron Mountain VA Medical Center (585)', 1 ),
( '   ah VA Medical Center (676)', 1 ),
( 'Madison Veterans Hospital (607)', 1 ),
( 'VA St. Louis Health Care System (657)', 1 ),
( 'Columbia MO VA Medical Center (589A4)', 1 ),
( 'Poplar Bluff VA Medical Center (657A4)', 1 ),
( 'Kansas City VA Medical Center (589)', 1 ),
( 'Marion VA Medical Center (657A5)', 1 ),
( 'Wichita VA Medical Center (589A7)', 1 ),
( 'VA Eastern Kansas Health Care System (589A5)', 1 ),
( 'Alexandria VA Health Care System (502)', 1 ),
( 'Central Arkansas Veterans Healthcare System (598)', 1 ),
( 'Jackson VA Medical Center (586)', 1 ),
( 'Gulf Coast Veterans Health Care System (520)', 1 ),
( 'Muskogee VA Medical Center (623)', 1 ),
( 'Houston VA Medical Center (580)', 1 ),
( 'Oklahoma City VA Medical Center (635)', 1 ),
( 'Shreveport VA Medical Center (667)', 1 ),
( 'Southeast Louisiana Veterans Health Care System (629)', 1 ),
( 'Veterans Health Care System of the Ozarks (564)', 1 ),
( 'Central Texas Veterans Health Care System (674)', 1 ),
( 'South Texas Veterans Health Care System (671)', 1 ),
( 'VA North Texas Health Care System (549)', 1 ),
( 'VA Texas Valley Coastal Bend Health Care System (740)', 1 ),
( 'Dallas VA Medical Center (549)', 1 ),
( 'Kerrville VA Hospital (671A4)', 1 ),
( 'Bonham VA Medical Center (549A4)', 1 ),
( 'VA Health Care Center at Harlingen (740)', 1 ),
( 'Waco VA Medical Center (674A4)', 1 ),
( 'Amarillo VA Health Care System (504)', 1 ),
( 'El Paso VA Health Care System (756)', 1 ),
( 'New Mexico VA Health Care System (501)', 1 ),
( 'Northern Arizona VA Health Care System (649)', 1 ),
( 'Phoenix VA Health Care System (644)', 1 ),
( 'Southern Arizona VA Health Care System (678)', 1 ),
( 'West Texas VA Health Care System (519)', 1 ),
( 'VA Eastern Colorado Health Care System (554)', 1 ),
( 'VA Montana Health Care System (436)', 1 ),
( 'VA Salt Lake City Health Care System (660)', 1 ),
( 'Cheyenne VA Medical (442)', 1 ),
( 'Grand Junction VA Medical Center (575)', 1 ),
( 'Sheridan VA Medical Center (666)', 1 ),
( 'Alaska VA Healthcare System (463)', 1 ),
( 'VA Puget Sound Health Care System (663)', 1 ),
( 'VA     burg Healthcare System (653)', 1 ),
( 'Boise VA Medical Center (531)', 1 ),
( 'Walla Walla VA Medical Center (687)', 1 ),
( 'Spokane VA Medical Center (668)', 1 ),
( 'Portland VA Medical Center (648)', 1 ),
( 'White City Oregon Rehabilitation Center (692)', 1 ),
( 'Livermore VA Medical Center (640)', 1 ),
( 'Menlo Park VA Medical Center (640)', 1 ),
( 'San Francisco VA Medical Center (662)', 1 ),
( 'VA Central California Health Care System (570)', 1 ),
( 'VA Northern California Health Care System (612)', 1 ),
( 'VA Pacific Islands Health Care System (459)', 1 ),
( 'VA Palo Alto Health Care System (640)', 1 ),
( 'VA Sierra Nevada Health Care System (654)', 1 ),
( 'VA Greater Los Angeles Healthcare System (691)', 1 ),
( 'VA Loma Linda Healthcare System (605)', 1 ),
( 'VA Long Beach Healthcare System (600)', 1 ),
( 'VA San Diego Healthcare System (664)', 1 ),
( 'VA Southern Nevada Healthcare System (593)', 1 ),
( 'Fargo VA Healthcare System (437)', 1 ),
( 'Iowa City VA Health Care System (636A8)', 1 ),
( 'Minneapolis VA Health Care System (618)', 1 ),
( 'Omaha - VA Nebraska - Western Iowa Health Care System (636)', 1 ),
( 'Sioux Falls VA Health Care System (438)', 1 ),
( 'St. Cloud VA Health Care System (656)', 1 ),
( 'VA Black Hills Health Care System (568A4)', 1 ),
( 'VA Central Iowa Health Care System (636A6)', 1 ),
( 'VISN 1: VA New England Healthcare System (10N1)', 1 ),
( 'VISN 2: VA Health Care Upstate New York (10N2)', 1 ),
( 'VISN 3: VA NY/NJ Veterans Healthcare Network (10N3)', 1 ),
( 'VISN 4: VA Healthcare - VISN 4 (10N4)', 1 ),
( 'VISN 5: VA Capitol Health Care Network (10N5)', 1 ),
( 'VISN 6: VA Mid-Atlantic Health Care Network (10N6)', 1 ),
( 'VISN 7: VA Southeast Network (10N7)', 1 ),
( 'VISN 8: VA Sunshine Healthcare Network (485)', 1 ),
( 'VISN 9: VA Mid South Healthcare Network (10N9)', 1 ),
( 'VISN 10: VA Healthcare System of Ohio (10N10)', 1 ),
( 'VISN 11: Veterans in Partnership (10N11)', 1 ),
( 'VISN 12: VA Great Lakes Health Care System (10N12)', 1 ),
( 'VISN 15: VA Heartland Network (10N15)', 1 ),
( 'VISN 16: South Central VA Health Care Network (10N16)', 1 ),
( 'VISN 17: VA Heart of Texas Health Care Network (10N17)', 1 ),
( 'VISN 18: VA Southwest Health Care Network (10N18)', 1 ),
( 'VISN 19: Rocky Mountain Network (10N19)', 1 ),
( 'VISN 20: Northwest Network (10N20)', 1 ),
( 'VISN 21: Sierra Pacific Network (10N21)', 1 ),
( 'VISN 22: Desert Pacific Healthcare Network (10N22)', 1 ),
( 'VISN 23: VA Midwest Health Care Network (10N23)', 1 ),
( 'Veterans Health Administration (VHA) - VACO, Non-VISN', 1 ),
( 'Veterans Benefits Administration (VBA)', 1 ),
( 'National Cemetery Administration (NCA)', 1 );

END

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailbox_settings]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[mailbox_settings](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[mailbox_id] [bigint] NOT NULL,
	[application_id] [bigint] NOT NULL,
	[web_service_id] [bigint] NOT NULL,
	[authorized] [tinyint] NOT NULL,
PRIMARY KEY CLUSTERED([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END

IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_mailbox_settings_application]') AND parent_object_id = OBJECT_ID(N'[dbo].[mailbox_settings]'))
BEGIN
ALTER TABLE [dbo].[mailbox_settings]  WITH CHECK ADD CONSTRAINT [FK_mailbox_settings_application] FOREIGN KEY([application_id])
REFERENCES [dbo].[application] ([id])
END

IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_mailbox_settings_web_services]') AND parent_object_id = OBJECT_ID(N'[dbo].[mailbox_settings]'))
BEGIN
ALTER TABLE [dbo].[mailbox_settings]  WITH CHECK ADD CONSTRAINT [FK_mailbox_settings_web_services] FOREIGN KEY([web_service_id])
REFERENCES [dbo].[web_services] ([id])
END

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[role_permissions]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[role_permissions](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[role_name] [varchar](150) NOT NULL,
	[permission_id] bigint NOT NULL,
 CONSTRAINT [PK_role_permissions] PRIMARY KEY NONCLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END
SET ANSI_PADDING OFF

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[role_permissions]') AND type in (N'U'))
BEGIN
SET IDENTITY_INSERT [dbo].[role_permissions] ON
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (1, N'facilityleader', 1)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (2, N'facilityleader', 2)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (3, N'facilityleader', 3)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (5, N'groupleader', 4)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (6, N'groupleader', 5)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (7, N'groupleader', 6)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (8, N'groupleader', 7)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (9, N'groupleader', 8)
INSERT [dbo].[role_permissions] ([id], [role_name], [permission_id]) VALUES (10, N'groupleader', 9)
SET IDENTITY_INSERT [dbo].[role_permissions] OFF
END

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[permissions]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[permissions](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[name] [varchar](100) NOT NULL,
	[parent_id] bigint NULL,
 CONSTRAINT [PK_permissions] PRIMARY KEY NONCLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END
SET ANSI_PADDING OFF

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[permissions]') AND type in (N'U'))
BEGIN
SET IDENTITY_INSERT [dbo].[permissions] ON
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (1, N'reports', NULL)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (2, N'user_activity_summary_report', 1)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (3, N'facility_report', 1)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (4, N'administration', NULL)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (5, N'manage_groups', 4)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (6, N'manage_groups_lead', 5)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (7,  ' n b e_group', 5)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (8, N'disable_group', 5)
INSERT [dbo].[permissions] ([id], [name], [parent_id]) VALUES (9, N'group_permissions', 5)
SET IDENTITY_INSERT [dbo].[permissions] OFF
END

 USE [master];
 IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'mail')
 BEGIN
 CREATE DATABASE [mail]
 ALTER DATABASE [mail] SET COMPATIBILITY_LEVEL = 100
 IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
 BEGIN
 EXEC [mail].[dbo].[sp_fulltext_database] @action = 'enable'
 END
 ALTER DATABASE [mail] SET ANSI_NULL_DEFAULT OFF 
 ALTER DATABASE [mail] SET ANSI_NULLS OFF 
 ALTER DATABASE [mail] SET ANSI_PADDING OFF 
 ALTER DATABASE [mail] SET ANSI_WARNINGS OFF 
 ALTER DATABASE [mail] SET ARITHABORT OFF 
 ALTER DATABASE [mail] SET AUTO_CLOSE OFF 
 ALTER DATABASE [mail] SET AUTO_CREATE_STATISTICS ON 
 ALTER DATABASE [mail] SET AUTO_SHRINK OFF 
 ALTER DATABASE [mail] SET AUTO_UPDATE_STATISTICS ON 
 ALTER DATABASE [mail] SET CURSOR_CLOSE_ON_COMMIT OFF 
 ALTER DATABASE [mail] SET CURSOR_DEFAULT  GLOBAL 
 ALTER DATABASE [mail] SET CONCAT_NULL_YIELDS_NULL OFF 
 ALTER DATABASE [mail] SET NUMERIC_ROUNDABORT OFF 
 ALTER DATABASE [mail] SET QUOTED_IDENTIFIER OFF 
 ALTER DATABASE [mail] SET RECURSIVE_TRIGGERS OFF 
 ALTER DATABASE [mail] SET  DISABLE_BROKER 
 ALTER DATABASE [mail] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
 ALTER DATABASE [mail] SET DATE_CORRELATION_OPTIMIZATION OFF 
 ALTER DATABASE [mail] SET TRUSTWORTHY OFF 
 ALTER DATABASE [mail] SET ALLOW_SNAPSHOT_ISOLATION OFF 
 ALTER DATABASE [mail] SET PARAMETERIZATION SIMPLE 
 ALTER DATABASE [mail] SET READ_COMMITTED_SNAPSHOT OFF 
 ALTER DATABASE [mail] SET HONOR_BROKER_PRIORITY OFF 
 ALTER DATABASE [mail] SET  READ_WRITE 
 ALTER DATABASE [mail] SET RECOVERY FULL 
 ALTER DATABASE [mail] SET  MULTI_USER
 ALTER DATABASE [mail] SET PAGE_VERIFY CHECKSUM  
 ALTER DATABASE [mail] SET DB_CHAINING OFF
 END
 GO

USE [mail];
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailboxes]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[mailboxes](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[name] [varchar](100) NOT NULL,
	[is_group] [tinyint] NULL,
	[is_active] [tinyint] NULL,
	[facility_id] [bigint] NULL,
 CONSTRAINT [PK_mailboxes] PRIMARY KEY NONCLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED ([name] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END
SET ANSI_PADDING OFF
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailboxes]') AND type in (N'U'))
BEGIN
ALTER TABLE [dbo].[mailboxes] ADD  DEFAULT ((0)) FOR [is_group]
ALTER TABLE [dbo].[mailboxes] ADD  DEFAULT ((1)) FOR [is_active]
INSERT INTO [mail].[dbo].[mailboxes] (name, is_group) SELECT [user_name],[user_is_group] FROM [direct].[dbo].users
END

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[folders]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[folders](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[name] [varchar](200) NOT NULL,
	[mailbox_id] [bigint] NOT NULL,
 CONSTRAINT [PK_folders] PRIMARY KEY NONCLUSTERED ([id] ASC)
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
SET ANSI_PADDING OFF
END
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[folders]') AND type in (N'U'))
BEGIN
ALTER TABLE [dbo].[folders]  WITH CHECK ADD  CONSTRAINT [FK_folder_mailbox2] FOREIGN KEY([mailbox_id])
REFERENCES [dbo].[mailboxes] ([id])
ON DELETE CASCADE
ALTER TABLE [dbo].[folders] CHECK CONSTRAINT [FK_folder_mailbox2]
END


SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[messages]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[messages](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[recipients] [varchar](max) NULL,
	[sender] [varchar](max) NOT NULL,
	[original_sender_id] [bigint] NULL,
	[to] [varchar](max) NULL,
	[cc] [varchar](max) NULL,
	[bcc] [varchar](max) NULL,
	[attachments] [varchar](max) NULL,
	[subject] [varchar](max) NULL,
	[plain] [varchar](max) NULL,
	[html] [varchar](max) NULL,
	[timestamp] [bigint] NOT NULL,
	[folder_id] [bigint] NULL,
	[size] [bigint] NULL,
	[flags] [varchar](max) NULL,
	[headers] [varchar](max) NOT NULL,
	[raw_mime] [varchar](max) NULL,
	[seen] [tinyint] NULL,
	[draft] [tinyint] NULL,
	[sent] [tinyint] NULL,
	[archived] [tinyint] NULL,
	[message_id] [varchar](max) NULL,
	[mailbox_id] [bigint] NOT NULL,
	[mailtype] [varchar](4) NOT NULL,
	[priority] [tinyint] NOT NULL,
 CONSTRAINT [PK_mailbox_username] PRIMARY KEY NONCLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END
SET ANSI_PADDING OFF
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[messages]') AND type in (N'U'))
BEGIN
ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [seen]
ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [draft]
ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [sent]
ALTER TABLE [dbo].[messages] ADD  DEFAULT ((0)) FOR [archived]
ALTER TABLE [dbo].[messages] ADD  DEFAULT ('html') FOR [mailtype]
ALTER TABLE [dbo].[messages]  WITH CHECK ADD  CONSTRAINT [FK_message_mailbox] FOREIGN KEY([mailbox_id])
REFERENCES [dbo].[mailboxes] ([id])
ALTER TABLE [dbo].[messages] CHECK CONSTRAINT [FK_message_mailbox]
ALTER TABLE [dbo].[messages]  WITH CHECK ADD  CONSTRAINT [FK_messages_folder] FOREIGN KEY([folder_id])
REFERENCES [dbo].[folders] ([id])
ON DELETE SET NULL
ALTER TABLE [dbo].[messages] CHECK CONSTRAINT [FK_messages_folder]
END



IF (select Count(*) from sys.certificates where name = 'TDE_Certificate') > 0

BEGIN
USE [mail];

CREATE DATABASE ENCRYPTION KEY

WITH ALGORITHM = AES_256

ENCRYPTION BY SERVER CERTIFICATE TDE_Certificate
ALTER DATABASE mail SET ENCRYPTION ON

END

USE [master];
IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'nhindconfig')

BEGIN

CREATE DATABASE [nhindconfig]
ALTER DATABASE [nhindconfig] SET COMPATIBILITY_LEVEL = 100


IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))

BEGIN

EXEC [nhindconfig].[dbo].[sp_fulltext_database] @action = 'enable'
END

ALTER DATABASE [nhindconfig] SET ANSI_NULL_DEFAULT OFF
ALTER DATABASE [nhindconfig] SET ANSI_NULLS OFF
ALTER DATABASE [nhindconfig] SET ANSI_PADDING OFF
ALTER DATABASE [nhindconfig] SET ANSI_WARNINGS OFF
ALTER DATABASE [nhindconfig] SET ARITHABORT OFF
ALTER DATABASE [nhindconfig] SET AUTO_CLOSE OFF
ALTER DATABASE [nhindconfig] SET AUTO_CREATE_STATISTICS ON
ALTER DATABASE [nhindconfig] SET AUTO_SHRINK OFF
ALTER DATABASE [nhindconfig] SET AUTO_UPDATE_STATISTICS ON
ALTER DATABASE [nhindconfig] SET CURSOR_CLOSE_ON_COMMIT OFF
ALTER DATABASE [nhindconfig] SET CURSOR_DEFAULT  GLOBAL
ALTER DATABASE [nhindconfig] SET CONCAT_NULL_YIELDS_NULL OFF
ALTER DATABASE [nhindconfig] SET NUMERIC_ROUNDABORT OFF
ALTER DATABASE [nhindconfig] SET QUOTED_IDENTIFIER OFF
ALTER DATABASE [nhindconfig] SET RECURSIVE_TRIGGERS OFF
ALTER DATABASE [nhindconfig] SET  DISABLE_BROKER
ALTER DATABASE [nhindconfig] SET AUTO_UPDATE_STATISTICS_ASYNC OFF
ALTER DATABASE [nhindconfig] SET DATE_CORRELATION_OPTIMIZATION OFF
ALTER DATABASE [nhindconfig] SET TRUSTWORTHY OFF
ALTER DATABASE [nhindconfig] SET ALLOW_SNAPSHOT_ISOLATION OFF
ALTER DATABASE [nhindconfig] SET PARAMETERIZATION SIMPLE
ALTER DATABASE [nhindconfig] SET READ_COMMITTED_SNAPSHOT OFF
ALTER DATABASE [nhindconfig] SET HONOR_BROKER_PRIORITY OFF
ALTER DATABASE [nhindconfig] SET  READ_WRITE
ALTER DATABASE [nhindconfig] SET RECOVERY FULL
ALTER DATABASE [nhindconfig] SET  MULTI_USER

ALTER DATABASE [nhindconfig] SET PAGE_VERIFY CHECKSUM 
ALTER DATABASE [nhindconfig] SET DB_CHAINING OFF

END
GO


USE [nhindconfig]

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailet_properties]') AND type in (N'U'))
BEGIN

CREATE TABLE [dbo].[mailet_properties](

[name] [varchar](50) NOT NULL,

[value] [varchar](max) NULL,

CONSTRAINT [PK_mailet_properties] PRIMARY KEY CLUSTERED ([name] ASC)

WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END

SET ANSI_PADDING OFF
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mailet_properties]') AND type in (N'U'))
BEGIN
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.smtp.host', N'localhost')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.smtp.port', N'587')

INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mail.transport.protocol', N'smtp')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apiname', N'api')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apipassword', N'')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.apiusername', N'api-db')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.encrypt', N'true')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.hostname', N'your_server200.aac.dva.domain')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.instance', N'your_server200')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailname', N'mail')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailpassword', N'')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.mailusername', N'api-db')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.port', N'1433')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webname', N'direct')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webpassword', N'')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.db.webusername', N'dpi-db')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.domain', N'direct.domain')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.folder', N'/u01/app/james-2.3.2/store/')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.private', N'1')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.aes', N'')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.error.refresh', N'5')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.api', N'dc=api')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.domain', N'dc=direct,dc=va,dc=gov')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.host', N'vadirappprd10.aac.domain')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.password', N'')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.port', N'389')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.protocol', N'ldap')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.ldap.user_dn', N'cn=admin,dc=direct,dc=va,dc=gov')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.notification.sender', N'notifications@direct.domain')
INSERT [dbo].[mailet_properties] ([name], [value]) VALUES (N'mailet.supportEmail', N'VADirectInfo@domain')

END